/*
 * Decompiled with CFR 0.152.
 */
package slick;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.BufferUtils;
import slick.AudioInputStream;
import slick.Log;

public class OggInputStream
extends InputStream
implements AudioInputStream {
    private InputStream input;
    private boolean endOfStream;
    byte[] buffer;
    int bytes = 0;
    boolean bigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
    boolean endOfBitStream = true;
    boolean inited = false;
    private int readIndex;
    private ByteBuffer pcmBuffer = BufferUtils.createByteBuffer(2048000);
    private int total;

    public OggInputStream(InputStream input) throws IOException {
        this.input = input;
        this.total = input.available();
        this.init();
    }

    public int getLength() {
        return this.total;
    }

    @Override
    public int getChannels() {
        return 0;
    }

    @Override
    public int getRate() {
        return 0;
    }

    private void init() throws IOException {
    }

    @Override
    public int available() {
        return this.endOfStream ? 0 : 1;
    }

    @Override
    public int read() throws IOException {
        if (this.readIndex >= this.pcmBuffer.position()) {
            this.pcmBuffer.clear();
            this.readIndex = 0;
        }
        if (this.readIndex >= this.pcmBuffer.position()) {
            return -1;
        }
        int value = this.pcmBuffer.get(this.readIndex);
        if (value < 0) {
            value += 256;
        }
        ++this.readIndex;
        return value;
    }

    @Override
    public boolean atEnd() {
        return this.endOfStream && this.readIndex >= this.pcmBuffer.position();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            block5: {
                block6: {
                    try {
                        int value = this.read();
                        if (value >= 0) {
                            b[i] = (byte)value;
                            break block5;
                        }
                        if (i != 0) break block6;
                        return -1;
                    }
                    catch (IOException e) {
                        Log.error(e);
                        return i;
                    }
                }
                return i;
            }
            ++i;
        }
        return len;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
    }
}

